<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Driver extends Model 
{

    protected $table = 'drivers';
    public $timestamps = true;
    protected $fillable = array('name', 'mobile', 'address', 'password', 'login_type', 'social_id', 'national_id', 'national_image', 'image', 'driving_license', 'drug_analysis', 'record_certificate', 'online_status', 'time_online', 'notifystatus', 'profits');

    public function car()
    {
        return $this->hasOne('App\Models\Car');
    }

    public function tokens()
    {
        return $this->hasMany('App\Models\Token');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification');
    }

    public function messages()
    {
        return $this->hasMany('App\Models\Message');
    }

    public function conversations()
    {
        return $this->hasMany('App\Models\Conversation');
    }

    public function rates()
    {
        return $this->hasMany('App\Models\Rate');
    }

    public function trips()
    {
        return $this->hasMany('App\Models\Trip');
    }

}